function [localmax,localmaxn,wcentroid,wcentroidn] = testthresh(imgs)
%A simple little function that tests how many objects you find using
%find_centroid with LocalMax and WeightedCentroid as a function of set
%threshold
%Synatax:   [] = mvdir();
%Input:     imgs = either a single image or an image stack
%Output:    localmax = localmax dataset [threshold# pivots# threshold%]
%           localmaxn = localmax contrast enhanced
%           wcentroid = weighted centroids
%           wcentroidn = weighted centroid enhanced

if nargin==0    %no input
    [filename,path,filterindex] = uigetfile2({'*.tif','TIFF files (*.tif)';...
        '*.jpg','Jpeg files (*.jpg)';'*.gif','GIF files (*.gif)';...
        '*.bmp','Bitmap files (*.bmp)';'*.mat','Mat files (*.mat)';},'Open Stack','Multiselect','off');
    [imgs] = stack_gui('filename',filename,'pathname',path,'filterindex',filterindex);
end

%get some image statistics
imgclass = class(imgs);      %get image type
%now figure out the image type of the image, not full proof, but works
%most of the time.  Note: this assumes the images are unsigned.
switch imgclass
    case 'uint8'
        img_max = intmax('uint8');      %the image is unsigned 8bit
    case 'uint16'
        img_max = intmax('uint16');     %the image is unsigned 16bit
    case 'uint32'
        img_max = intmax('uint32');     %unsigned 32bit, like I said not full proof, but works for now.
    case 'double'
        img_max = 1;        %double
end
img_max = double(img_max);  %maintain the var as double, the pivot # will saturate.

%initiate data
localmax = [];
localmaxn = [];     %normalized
wcentroid = [];    
wcentroidn = [];    
%progress bar
h = waitbar(0,'Test Thresholds: 0','position',[10 50 275 50]);
for i = 0:0.001:1   %go through desired threshold levels
    waitbar(1*i,h,['Test Threshold: ',num2str(i)]);   %update progress
    try     %not an elegant solution, but will work
        [pivots] = find_centroid('stks',imgs,'save',0,'type',0,'norm',1,'threshold',i);     %localmax
    catch
        pivots = {[]};
    end
    localmaxn = vertcat(localmaxn,[img_max*i,size(pivots{1},1),i]);
    try
    [pivots] = find_centroid('stks',imgs,'save',0,'type',0,'norm',0,'threshold',i);     %localmax
    catch
        pivots = {[]};
    end
    localmax = vertcat(localmax,[img_max*i,size(pivots{1},1),i]);
    try
        [pivots] = find_centroid('stks',imgs,'save',0,'type',2,'norm',1,'threshold',i);     %weighted centroid
    catch
        pivots = {[]};
    end
    wcentroidn = vertcat(wcentroidn,[img_max*i,size(pivots{1},1),i]);
    try
        [pivots] = find_centroid('stks',imgs,'save',0,'type',2,'norm',0,'threshold',i);     %weighted centroid
    catch
        pivots = {[]};
    end
    wcentroid = vertcat(wcentroid,[img_max*i,size(pivots{1},1),i]);
end
close(h)

%plot the data
figure('Name','LocalMax','NumberTitle','off');
plot(localmax(:,2));
ylabel('# of pivots');
xlabel(['Threshold from 0-1, which is 0-',num2str(img_max)]);
figure('Name','LocalMax Normalized','NumberTitle','off');
plot(localmaxn(:,2));
ylabel('# of pivots');
xlabel(['Threshold from 0-1, which is 0-',num2str(img_max)]);
figure('Name','WeightedCentroid','NumberTitle','off');
plot(wcentroid(:,2));
ylabel('# of pivots');
xlabel(['Threshold from 0-1, which is 0-',num2str(img_max)]);
figure('Name','WeightedCentroid Normalized','NumberTitle','off');
plot(wcentroidn(:,2));
ylabel('# of pivots');
xlabel(['Threshold from 0-1, which is 0-',num2str(img_max)]);